#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/4sVfWw

#define HASHSCALE3 vec3(.1031, .1030, .0973)

#define detail 5
#define steps 300
#define time iTime*0.5
#define maxdistance 30.0

//#define drawgrid
#define fog
//#define borders
#define blackborders
//#define raymarchhybrid 100
#define objects
#define emptycells 0.5
#define subdivisions 0.95 //should be higher than emptycells

#define rot(spin) mat2(cos(spin),sin(spin),-sin(spin),cos(spin))

#define sqr(a) (a*a)

//random function from https://www.shadertoy.com/view/MlsXDf
float rnd(vec4 v) { return fract(4e4*sin(dot(v,vec4(13.46,41.74,-73.36,14.24))+17.34)); }

//hash function by Dave_Hoskins https://www.shadertoy.com/view/4djSRW
vec3 hash33(vec3 p3)
{
	p3 = fract(p3 * HASHSCALE3);
    p3 += dot(p3, p3.yxz+19.19);
    return fract((p3.xxy + p3.yxx)*p3.zyx);
}

//0 is empty, 1 is subdivide and 2 is full
int getvoxel(vec3 p, float size) {
#ifdef objects
    if (p.x==0.0&&p.y==0.0) {
        return 0;
    }
#endif
    
    float val = rnd(vec4(p,size));
    
    if (val < emptycells) {
        return 0;
    } else if (val < subdivisions) {
        return 1;
    } else {
        return 2;
    }
    
    return int(val*val*3.0);
}

//ray-cube intersection, on the inside of the cube
vec3 voxel(vec3 ro, vec3 rd, vec3 ird, float size)
{
    size *= 0.5;
    
    vec3 hit = -(sign(rd)*(ro-size)-size)*ird;
    
    return hit;
}

float map(vec3 p, vec3 fp) {
    p -= 0.5;
    
    vec3 flipping = floor(hash33(fp)+0.5)*2.0-1.0;
    
    p *= flipping;
    
    vec2 q = vec2(abs(length(p.xy-0.5)-0.5),p.z);
    float len = length(q);
    q = vec2(abs(length(p.yz-vec2(-0.5,0.5))-0.5),p.x);
    len = min(len,length(q));
    q = vec2(abs(length(p.xz+0.5)-0.5),p.y);
    len = min(len,length(q));
    
    
    return len-0.1666;
}

vec3 findnormal(vec3 p, float epsilon, vec3 fp)
{
    vec2 eps = vec2(0,epsilon);
    
    vec3 normal = vec3(
        map(p+eps.yxx,fp)-map(p-eps.yxx,fp),
        map(p+eps.xyx,fp)-map(p-eps.xyx,fp),
        map(p+eps.xxy,fp)-map(p-eps.xxy,fp));
    return normalize(normal);
}

void mainImage( out vec4 fragColor,  vec2 fragCoord )
{
    
    fragColor = vec4(0.0);
    vec2 uv = (fragCoord.xy * 2.0 - iResolution.xy) /iResolution.y;
    float size = 1.0;
    
    vec3 ro = vec3(0.5+sin(time)*0.4,0.5+cos(time)*0.4,time);
    vec3 rd = normalize(vec3(uv,1.0));
    
    //if the mouse is in the bottom left corner, don't rotate the camera
    if (length(iMouse.xy) > 40.0) {
    	rd.yz *= rot(iMouse.y/iResolution.y*3.14-3.14*0.5);
    	rd.xz *= rot(iMouse.x/iResolution.x*3.14*2.0-3.14);
    }
    
    vec3 lro = mod(ro,size);
    vec3 fro = ro-lro;
    vec3 ird = 1.0/max(abs(rd),0.001);
    vec3 mask;
    bool exitoct = false;
    int recursions = 0;
    float dist = 0.0;
    float fdist = 0.0;
    int i;
    float edge = 1.0;
    vec3 lastmask;
    vec3 normal = vec3(0.0);
    
    //the octree traverser loop
    //each iteration i either:
    // - check if i need to go up a level
    // - check if i need to go down a level
    // - check if i hit a cube
    // - go one step forward if octree cell is empty
    // - repeat if i did not hit a cube
    for (i = 0; i < steps; i++)
    {
        if (dist > maxdistance) break;
        
        //i go up a level
        if (exitoct)
        {
            
            vec3 newfro = floor(fro/(size*2.0))*(size*2.0);
            
            lro += fro-newfro;
            fro = newfro;
            
            recursions--;
            size *= 2.0;
            
            exitoct = (recursions > 0) && (abs(dot(mod(fro/size+0.5,2.0)-1.0+mask*sign(rd)*0.5,mask))<0.1);
        }
        else
        {
            //checking what type of cell it is: empty, full or subdivide
            int voxelstate = getvoxel(fro,size);
            if (voxelstate == 1 && recursions > detail)
            {
                voxelstate = 0;
            }
            
            if(voxelstate == 1&&recursions<=detail)
            {
                //if(recursions>detail) break;

                recursions++;
                size *= 0.5;

                //find which of the 8 voxels i will enter
                vec3 mask2 = step(vec3(size),lro);
                fro += mask2*size;
                lro -= mask2*size;
            }
            //move forward
            else if (voxelstate == 0||voxelstate == 2)
            {
                //raycast and find distance to nearest voxel surface in ray direction
                //i don't need to use voxel() every time, but i do anyway
                vec3 hit = voxel(lro, rd, ird, size);

                /*if (hit.x < min(hit.y,hit.z)) {
                    mask = vec3(1,0,0);
                } else if (hit.y < hit.z) {
                    mask = vec3(0,1,0);
                } else {
                    mask = vec3(0,0,1);
                }*/
                mask = vec3(lessThan(hit,min(hit.yzx,hit.zxy)));
                float len = dot(hit,mask);
    #ifdef objects
                if (voxelstate == 2) {
    #ifdef raymarchhybrid
                    //if (length(fro-ro) > 20.0*size) break;
                    vec3 p = lro/size;
                    if (map(p,fro) < 0.0) {
                        normal = -lastmask*sign(rd);
                        break;
                    }
                    float d = 0.0;
                    bool hit = false;
                    float e = 0.001/size;
                    for (int j = 0; j < raymarchhybrid; j++) {
                        float l = map(p,fro);
                        p += l*rd;
                        d += l;
                        if (l < e || d > len/size) {
                            if (l < e) hit = true;
                            d = min(len,d);
                            break;
                        }
                    }
                    if (hit) {
                        dist += d*size;
                        ro += rd*d*size;
                        normal = findnormal(p,e,fro);//(lro-0.5)*2.0;
                        break;
                    }
    #else
                    break;
    #endif
                }
    #endif

                //moving forward in ray direction, and checking if i need to go up a level
                dist += len;
                fdist += len;
                lro += rd*len-mask*sign(rd)*size;
                vec3 newfro = fro+mask*sign(rd)*size;
                exitoct = (floor(newfro/size*0.5+0.25)!=floor(fro/size*0.5+0.25))&&(recursions>0);
                fro = newfro;
                lastmask = mask;
            }
        }
#ifdef drawgrid
        vec3 q = abs(lro/size-0.5)*(1.0-lastmask);
        edge = min(edge,-(max(max(q.x,q.y),q.z)-0.5)*80.0*size);
#endif
    }
    ro += rd*dist;
    if(i < steps && dist < maxdistance)
    {
    	float val = fract(dot(fro,vec3(15.23,754.345,3.454)));
#ifndef raymarchhybrid
        vec3 normal = -lastmask*sign(rd);
#endif
        vec3 color = sin(val*vec3(39.896,57.3225,48.25))*0.5+0.5;
    	fragColor = vec4(color*(normal*0.25+0.75),1.0);
        
#ifdef borders
        vec3 q = abs(lro/size-0.5)*(1.0-lastmask);
        edge = clamp(-(max(max(q.x,q.y),q.z)-0.5)*20.0*size,0.0,edge);
#endif
#ifdef blackborders
        fragColor *= edge;
#else
        fragColor = 1.0-(1.0-fragColor)*edge;
#endif
    } else {
        #ifdef blackborders
                fragColor = vec4(edge);
        #else
                fragColor = vec4(1.0-edge);
        #endif
    }
#ifdef fog
    fragColor *= 1.0-dist/maxdistance;
#endif
    fragColor = sqrt(fragColor);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


